# The class gwaa.data-class 
install.packages('GenABEL')
library(GenABEL)
data(srdta)
phdata(srdta)[1:5, ]
gtdata(srdta[1:5, 1:5])
nids(srdta)
nsnps(srdta)
idnames(srdta)[1:5]
male(srdta)[1:5]
table(male(srdta))
snpnames(srdta)[1:5]
chromosome(srdta)[1:5]
map(srdta)[1:5]
snpnames(srdta)[map(srdta)>1100000 & map(srdta)<1105000]
coding(srdta)[1:5]
strand(srdta)[1:5]

# Adding and deleting phenotypes
age2 <- phdata(srdta)$age^2
srdta <- add.phdata(srdta, newph = age2, name = "age_squared")
phdata(srdta)[1:5, ]
set.seed(1980)
newvalues <- matrix(rnorm(3 * 5), 3, 5)
newdata <- data.frame(id = c("p1", "p2", "p4"), ph1 = 1, ph2 = 1,
ph3 = 1, ph4 = 1, ph5 = 1)
newdata[, c(2:6)] <- newvalues
srdta <- add.phdata(srdta, newdata)
phdata(srdta)[1:5, ]
srdta <- del.phdata(srdta, c("age_squared", "ph1", "ph2", "ph3", "ph4", "ph5"))
phdata(srdta)[1:5, ]

# Sub-setting and coercing gwaa.data
ssubs <- srdta[1:5, 1:3]
phdata(ssubs)
gtdata(ssubs)
as.character(gtdata(ssubs))
as.numeric(gtdata(ssubs))
ssubs2 <- srdta[c("p141", "p147", "p2000"), c("rs10", "rs29")]
gtdata(ssubs2)

# Exploring genetic data
summary(ssubs)
vec <- (phdata(srdta)$age >= 65)
table(vec)
summary(gtdata(srdta[vec, 1:3]))
summary(gtdata(srdta[phdata(srdta)$bt == 0, 1:10]))
perid.summary(srdta[1:5, ])

# GWA analysis using family-based data
load("erfsmall.RData")
class(erfs)
class(pkins)
nids(erfs)
nsnps(erfs)
table(chromosome(erfs))
descriptives.marker(gtdata(erfs))

# Kinship coefficients
pkins[1:5, 1:5]
summary(pkins[lower.tri(pkins)])
hist(pkins[lower.tri(pkins)])
gkins <- ibs(erfs[, autosomal(erfs)], weight = "freq")
gkins[1:5, 1:5]
summary(gkins[lower.tri(gkins)])
hist(gkins[lower.tri(gkins)])
cor(pkins[lower.tri(pkins)], gkins[lower.tri(gkins)])
plot(pkins[lower.tri(pkins)], gkins[lower.tri(gkins)])

# Polygenic model and GRAMMAS analysis
h2 <- polygenic(qtbas, kin = pkins, data = erfs)
h2$h2an
grs <- qtscore(h2$pgres, data = erfs, clam = FALSE)
lambda(grs)$est
descriptives.scan(grs, sort = "Pc1df")
grs.e <- qtscore(h2$pgres, data = erfs, times = 200, clam = FALSE, quiet = TRUE)
descriptives.scan(grs.e, sort = "Pc1df")